// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedure for creating One Time Pad Key files.
//...............................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	int					iNumberOfFiles;
extern	int					iStepIncrement;
extern	BOOL				bAviClipOK;
extern	HWND				hAviClip;
extern	LPCTSTR				lpszNullString;
extern	NUMBERFMT			nFormatInfo;
extern	TCHAR				szDestination[MAX_PATH];
extern	int					iWhichAviClip;
extern	HICON				hIcon;
extern	LPCTSTR				lpszCdRom;
extern	LPCTSTR				lpszDisk35;
extern	LPCTSTR				lpszDisk525;
extern	LPCTSTR				lpszHardDisk;
extern	LPCTSTR				lpszRemoteDisk;
extern	TCHAR				OTPFileID;
extern	BOOL				bIsWin9x;
extern	SHFILEINFO			shfi1;
extern	BOOL				bUseNew;
extern	CONFIG				cfg;

// Local variables.
//.................
BOOL			bUseDateSuffix;
int				iBaseNameLength;
int				iSubFolderLength;
LPCTSTR			lpszWhichDriveIcon;
DWORD			dwOtpFilesToCreate;
ULARGE_INTEGER	uliTotalOtpFiles;
LPTSTR			lpszOtpKeyFormat = "%s OTP Key Files can be created on the selected drive.";
LPTSTR			lpszDestinationFormat = "Destination Drive: %s";
TCHAR			szRoot[16];
TCHAR			szBaseName[MAX_PATH];
TCHAR			szSubFolder[MAX_PATH];
LPTSTR			lpszFileDateFormat = "%s %s.otp";
LPTSTR			lpszFileNumberFormat = "%s %0.6u.otp";
LPCTSTR			lpszDateFormat = "ddd',' dd MMM yyyy";
TCHAR			szRoot[16];

// Structure to get the sector size and sectors per cluster
// using an int 21h call.
//.........................................................
EXTGETDSKFRESPCSTRUC	egdfss;
DIOC_REGISTERS			reg;

// Create one or more one time pad key files.
//...........................................
VOID CreateOneTimePads()
{
	ULARGE_INTEGER	uliFreeCallerBytes;
	ULARGE_INTEGER	uliTotalBytes;
	ULARGE_INTEGER	uliFreeBytes;
	DWORD			dwOldHelpTopic;
	BOOL			bResult;
	BOOL			bDiskError = FALSE;
	HANDLE			hDevice;
	DWORD			dwCountBytes;
	DWORD			dwClusterSize;
	DWORD			dwClustersPerFile;
	DWORD			dwBytesPerFile;
	BROWSEINFO		bi;
	HRESULT			hr = ERROR_SUCCESS;
    LPITEMIDLIST	lpidl;
    LPMALLOC		lpMalloc;
	UINT			uiDriveType;
	int				iResult;
	DWORD			dwNumberSuffix;
	TCHAR			szDateSuffix[48];
	SYSTEMTIME		st;
	DWORD			dwJulianDayNumber;
	LPBYTE			lpOtpFileBuffer = 0;
	LPBYTE			lpOtpFileBufferDup;
	TCHAR			szInBuffer[MAX_PATH];
	TCHAR			szSuffixBuffer[48];
	LPTSTR			lpszFileNameInsert;
	DWORD			dwNumbersWanted;
	DWORD			dwTestNumber;
	HANDLE			hOtpFile = 0;
	DWORD			dwBytesWritten;
	TCHAR			szBuffer[32];

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_CREATEONETIMEPADS);

	// Set the current directory.
	//...........................
	SetCurrentDirectory((LPCTSTR)&cfg.szPreviousOTPKeyFiles);

	if (BPC())
	{
		goto OtpEnd;
	}
	// Get the destination for our one time pad key files.
	//....................................................
	while(TRUE)
	{
		ZeroMemory(&szDestination,sizeof(szDestination));

		if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
		{
			ZeroMemory(&bi,sizeof(bi));
			bi.hwndOwner = hMainWindow;
			bi.pszDisplayName = 0;
			bi.lpszTitle = TEXT("Select a destination for the One Time Pad Key Files.\nYou may add a subfolder in the next dialog box.");
			bi.pidlRoot = 0;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;

			// If we can use the new style of the dialog box, do it.
			//......................................................
			if (bUseNew)
			{
				hr = CoInitialize(NULL);
				if (SUCCEEDED(hr))
				{
					bi.ulFlags |= BIF_NEWDIALOGSTYLE;
				}
			}
			bi.lpfn = BrowseCallbackProc;

			lpidl = SHBrowseForFolder(&bi);

			if (bUseNew && SUCCEEDED(hr))
			{
				CoUninitialize();
			}
			if (lpidl) 
			{
				bResult = SHGetPathFromIDList(lpidl,szDestination);
				lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
				lpMalloc->lpVtbl->Release(lpMalloc);
			}
			else
			{
				// We cancelled out.
				//..................
				goto OtpEnd;
			}
			SaveDirName((LPBYTE)&szDestination,SAVE_OTPKEYFILES | SAVE_SOURCE,FALSE);

			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero.
			//.......................................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,
										(PULARGE_INTEGER)&uliFreeBytes);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				goto OtpEnd;
			}
			if (uliFreeCallerBytes.QuadPart < OTPFileSize)
			{
				SetLastError(IDS_INSUFFICIENTSPACE);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			// Make sure we have a valid drive type.
			//......................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,sizeof(szRoot));
			PathStripToRoot((LPTSTR)&szRoot);
			uiDriveType = GetDriveType((LPCTSTR)&szRoot);

			// We do not want to store the files on a ram disk.
			//.................................................
			if (uiDriveType == DRIVE_RAMDISK)
			{
				SetLastError(IDS_RAMDRIVE);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETDRIVETYPE,MB_OK);
				continue;
			}
			// Determine the maximum length of the base name.
			//...............................................
			iResult = lstrlen((LPCTSTR)&szDestination);
			iBaseNameLength = (MAX_PATH - iResult - 44);
			if (iBaseNameLength < 10)
			{
				SetLastError(IDS_NOROOMFORBASENAME);
				ErrorProcedure((LPTSTR)&szDestination,IDS_BROWSEFORFOLDER,MB_OK);
				continue;
			}
			// If we go this far with no error, we have a valid
			// destination.
			//.................................................
			break;
		}
		else
		{
			// Unknown system error encountered while trying to
			// browse for a directory.
			//.................................................
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto OtpEnd;
		}
	}
	// Determine which avi clip to use: file copy, file disk,
	// or file cd rom.
	//.......................................................
	iWhichAviClip = FILE_COPY;
	if (uiDriveType == DRIVE_REMOVABLE && (*szDestination == 0x41 ||
		*szDestination == 0x61 || *szDestination == 0x42 ||
		*szDestination == 0x62))
	{
		iWhichAviClip = FILE_DISK;
	}
	else if (uiDriveType == DRIVE_CDROM)
	{
		iWhichAviClip = FILE_CDROM;
	}

	uliTotalOtpFiles.QuadPart = 0;

	if (bIsWin9x)
	{
		ZeroMemory(&egdfss,sizeof(EXTGETDSKFRESPCSTRUC));
		hDevice = CreateFile("\\\\.\\vwin32",0,0,NULL,0,FILE_FLAG_DELETE_ON_CLOSE,NULL);
		
		reg.reg_EDI = (DWORD)&egdfss;
		reg.reg_ECX = sizeof(EXTGETDSKFRESPCSTRUC);
		reg.reg_EAX = 0x7303;
		reg.reg_EDX = (DWORD)&szRoot;

		bResult = DeviceIoControl(hDevice,VWIN32_DIOC_DOS_DRIVEINFO,&reg,sizeof(reg),
								  &reg,sizeof(reg),&dwCountBytes,0);

		if (bResult && !(reg.reg_Flags & 0x0001))
		{
			dwClusterSize = (egdfss.ExtFree_BytesPerSector * egdfss.ExtFree_SectorsPerCluster);
			__asm
			{
				xor		edx,edx
				mov		eax,(OTPFileSize + 260)
				mov		ecx,dwClusterSize
				div		ecx
				cmp		edx,0
				jz		L1
				inc		eax
			L1:	mov		dwClustersPerFile,eax
			}
			dwBytesPerFile = (dwClusterSize * dwClustersPerFile);
			uliTotalOtpFiles.QuadPart = (uliFreeCallerBytes.QuadPart / dwBytesPerFile);
		}
		CloseHandle(hDevice);
	}
	// Determine the total number of otp key files we can make on
	// the destination disk for Windows NT, or if we did not do it
	// for Windows 95/98. Not very accurate.
	//...........................................................
	if (uliTotalOtpFiles.QuadPart == 0)
	{
		uliTotalOtpFiles.QuadPart = (uliFreeCallerBytes.QuadPart/(OTPFileSize + 600));
	}
	// Determine the correct drive icon to use for the dialog box.
	//............................................................
	lpszWhichDriveIcon = lpszDisk35;
	if (uiDriveType == DRIVE_CDROM)
	{
		lpszWhichDriveIcon = lpszCdRom;
	}
	else if (uiDriveType == DRIVE_REMOTE)
	{
		lpszWhichDriveIcon = lpszRemoteDisk;
	}
	else if (uiDriveType == DRIVE_FIXED)
	{
		lpszWhichDriveIcon = lpszHardDisk;
	}
	else if (uliTotalBytes.QuadPart < (360 * 1024))
	{
		lpszWhichDriveIcon = lpszDisk525;
	}
	else if (uliTotalBytes.QuadPart < (720 * 1024))
	{
		lpszWhichDriveIcon = lpszDisk35;
	}
	else if (uliTotalBytes.QuadPart < (1229 * 1024))
	{
		lpszWhichDriveIcon = lpszDisk525;
	}
	// Display our dialog box asking how many otp key files we
	// want to make.
	//........................................................
	iResult = DialogBox(hInst,TEXT("HOWMANYOTPKEYFILES"),hMainWindow,
					   (DLGPROC)HowManyOtpKeyFilesProc);

	// Destroy the icon if we used it.
	//................................
	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto OtpEnd;
	}
	// Quit if we canceled.
	//.....................
	if (iResult == IDCANCEL)
	{
		goto OtpEnd;
	}
	// Setup the destination path name to reflect our choice.
	//.......................................................
	PathAddBackslash((LPTSTR)&szDestination);
	
	// If we have added a subfolder attach it and create it.
	//......................................................
	if (iSubFolderLength)
	{
		StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szSubFolder,
					   NULL,NULL,dwStringSafeFlag);
		bResult = CreateDirectory((LPCTSTR)&szDestination,NULL);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szDestination,IDS_CREATEDIRECTORY,MB_OK);
			goto OtpEnd;
		}
		PathAddBackslash((LPTSTR)&szDestination);
	}
	// Append the base name to the specification.
	//...........................................
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)szBaseName,NULL,NULL,
				   dwStringSafeFlag);
	lpszFileNameInsert = PathFindFileName((LPCTSTR)&szDestination);

	// Setup the suffix to use for the file names.
	//............................................
	if (bUseDateSuffix)
	{
		ZeroMemory(&szDateSuffix,sizeof(szDateSuffix));
		GetLocalTime(&st);
		dwJulianDayNumber = DateToJulian(&st);
	}
	else
	{
		// Use a number suffix.
		//.....................
		dwNumberSuffix = 1;
	}
	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;
	iNumberOfFiles = dwOtpFilesToCreate;

	// Allocate the memory for write buffer.
	//......................................
	lpOtpFileBuffer = AllocateMemory(1303 * 4);
	if (!lpOtpFileBuffer)
	{
		goto OtpEnd;
	}
	// Setup the modeless dialog box for creating the files.
	//......................................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("CREATEOTPFILES"),hMainWindow,
								  (DLGPROC)CreateOtpFilesProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto OtpEnd;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Create the otp key files.
	//..........................
	while(dwOtpFilesToCreate > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		// Setup the file name and send it to the dialog box.
		//...................................................
		if (bUseDateSuffix)
		{
			JulianToDate(&st,dwJulianDayNumber);
			GetDateFormat(LOCALE_USER_DEFAULT,0,&st,lpszDateFormat,
						 (LPTSTR)&szSuffixBuffer,sizeof(szSuffixBuffer));
			StringCbPrintf((LPTSTR)&szInBuffer,sizeof(szInBuffer),lpszFileDateFormat,
						    &szBaseName,&szSuffixBuffer);
			*lpszFileNameInsert = 0;
			StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szInBuffer,
						   NULL,NULL,dwStringSafeFlag);
			dwJulianDayNumber++;
		}
		else
		{
			// Use number suffix.
			//...................
			StringCbPrintf((LPTSTR)&szInBuffer,sizeof(szInBuffer),lpszFileNumberFormat,
						    &szBaseName,dwNumberSuffix);
			*lpszFileNameInsert = 0;
			StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szInBuffer,
						   NULL,NULL,dwStringSafeFlag);
			dwNumberSuffix++;
		}
		// Fill the buffer with random numbers.
		//.....................................
		dwNumbersWanted = Goal;
		lpOtpFileBufferDup = lpOtpFileBuffer;
		StirTheBits();
		while(dwNumbersWanted > 0)
		{
			while(TRUE)
			{
				GetRandomBits(32,&dwTestNumber);
				if (dwTestNumber >= 100000001)
				{
					break;
				}
			}
			__asm
			{
				mov		edi,lpOtpFileBufferDup
				mov		eax,dwTestNumber
				stosd
				mov		lpOtpFileBufferDup,edi
			}
			EmptyTheMessageQue();
			if (bCancelOperation == TRUE)
			{
				break;
			}
			dwNumbersWanted--;
		}
		if (bCancelOperation == TRUE)
		{
			break;
		}
		// We always have a disk error.
		//.............................
		bDiskError = TRUE;

		// Create and write the otp key file.
		//...................................
		hOtpFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,
						         NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hOtpFile)
		{
			goto OtpEnd;
		}
		// Write the name of the file to the dialog box.
		//..............................................
		SetDlgItemTextFmt(hDialogModeLess,IDC_OTPKEYFILE,
						 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));		

		// Write the 4 byte header.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szDestination,hOtpFile,
							  (LPCVOID)&OTPFileID,4,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto OtpEnd;
		}
		// Write the buffer of random numbers.
		//....................................
		bResult = WriteMyFile((LPTSTR)&szDestination,hOtpFile,
							  lpOtpFileBuffer,(Goal * 4),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto OtpEnd;
		}
		bResult = CloseMyHandle((LPTSTR)&szDestination,hOtpFile);
		if (!bResult)
		{
			goto OtpEnd;
		}
		hOtpFile = 0;
		bDiskError = FALSE;

		// Update the progress bar.
		//.........................
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
		dwOtpFilesToCreate--;

		// Update the number of files left.
		//.................................
		FormatMyNumber(dwOtpFilesToCreate,(LPTSTR)&szBuffer,sizeof(szBuffer));
		SetDlgItemText(hDialogModeLess,IDC_NUMBERLEFT,(LPCTSTR)&szBuffer);
	}
	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,
			       (WPARAM)iNumberOfFiles,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}

	OtpEnd:

	FlashMyIcon(FALSE);

	if (hOtpFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOtpFile);
		if (bDiskError == TRUE)
		{
			DeleteMyFile((LPTSTR)&szDestination);
		}
	}

	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (lpOtpFileBuffer)
	{
		ZeroMemory(lpOtpFileBuffer,(1303 * 4));
		DeallocateMemory(lpOtpFileBuffer);
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for asking how many otp key files we
// want to make.
//........................................................
LRESULT CALLBACK HowManyOtpKeyFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL		bError;
	int			iBaseLength;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR		szInBuffer[128];
			TCHAR		szFormatedNumber[64];
			TCHAR		szCompactedPath[MAX_PATH];		
			
			// Clear the base name variable.
			//..............................
			ZeroMemory(&szBaseName,sizeof(szBaseName));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the drive icon to use.
			//.............................
			hIcon = LoadImage(hInst,lpszWhichDriveIcon,IMAGE_ICON,32,32,LR_SHARED);
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_DRIVEICON),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Set the destination.
			//.....................
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDestinationFormat,&szRoot);
			SetDlgItemTextFmt(hDlg,IDC_DESTINATION,(LPCTSTR)szInBuffer);

			// Set the statement for how many otp key files we
			// can create on the drive.
			//................................................
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			_ui64toa(uliTotalOtpFiles.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszOtpKeyFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_STATEMENT1,(LPCTSTR)szInBuffer);

			// Setup the edit box.
			//....................
			SetDlgItemInt(hDlg,IDC_OTPKEYFILES,0,FALSE);
			SendDlgItemMessage(hDlg,IDC_OTPKEYFILES,EM_SETLIMITTEXT,(WPARAM)6,0);

			// Set the full destination specification.
			//........................................
			PathCompactPathEx((LPTSTR)&szCompactedPath,(LPCTSTR)&szDestination,75,0);
			SetDlgItemTextFmt(hDlg,IDC_DESTINATION1,(LPCTSTR)&szCompactedPath);

			// Set the text limit for the subfolder.
			//......................................
			SendDlgItemMessage(hDlg,IDC_SUBFOLDER,EM_SETLIMITTEXT,(WPARAM)20,0);
			ZeroMemory(&szSubFolder,sizeof(szSubFolder));

			// Set the text limits for the base file name.
			//............................................
			SendDlgItemMessage(hDlg,IDC_BASENAME,EM_SETLIMITTEXT,(WPARAM)iBaseNameLength,0);

			// Check the date suffix radiobutton.
			//...................................
			CheckRadioButton(hDlg,IDC_DATESUFFIX,IDC_NUMBERSUFFIX,IDC_DATESUFFIX);
			bUseDateSuffix = TRUE;

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_DATESUFFIX:
				{
					CheckRadioButton(hDlg,IDC_DATESUFFIX,IDC_NUMBERSUFFIX,IDC_DATESUFFIX);
					bUseDateSuffix = TRUE;
				}
				break;

				case IDC_NUMBERSUFFIX:
				{
					CheckRadioButton(hDlg,IDC_DATESUFFIX,IDC_NUMBERSUFFIX,IDC_NUMBERSUFFIX);
					bUseDateSuffix = FALSE;
				}
				break;

				case IDOK:
				{
					// Check out the number of otp key files wanted.
					//..............................................
					dwOtpFilesToCreate = GetDlgItemInt(hDlg,IDC_OTPKEYFILES,&bError,FALSE);
					if (dwOtpFilesToCreate == 0 ||
						dwOtpFilesToCreate > uliTotalOtpFiles.QuadPart ||
						dwOtpFilesToCreate > 999999)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_FILESOTP,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_OTPKEYFILES));
						break;
					}
					// Retrieve and check out the subfolder.
					//......................................
					GetDlgItemText(hDlg,IDC_SUBFOLDER,szSubFolder,sizeof(szSubFolder)-1);
					iSubFolderLength = lstrlen(szSubFolder);

					// Check out the base name length.
					//................................
					GetDlgItemText(hDlg,IDC_BASENAME,szBaseName,sizeof(szBaseName)-1);
					iBaseLength = lstrlen(szBaseName);

					if (iBaseLength == 0)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_NOBASENAME,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BASENAME));
						break;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for creating otp key files dialog box.
//..........................................................
LRESULT CALLBACK CreateOtpFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR		szBuffer[32];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)iNumberOfFiles);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Set the initial value for the number of files left to
			// create.
			//......................................................
			FormatMyNumber(dwOtpFilesToCreate,(LPTSTR)&szBuffer,sizeof(szBuffer));
			SetDlgItemText(hDlg,IDC_NUMBERLEFT,(LPCTSTR)&szBuffer);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}
